﻿using System;
using VRM.Integration.Servicebus.Core;

namespace VIMT.VideoVisit.Services.Configuration
{
    public class VideoVisitSecurityConfiguration : ObjectConfigHandler
    {
        public static VideoVisitSecurityConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<VideoVisitSecurityConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath,
                     ConfigurationLocation.GetConfigFilePath("EC"),
                    "VideoVisitSecurityConfiguration");

                if (section == null) throw new Exception("The Video Visit Service Security configuration section has not been specified");

                return section;
            }
        }
        
        public string BaseUri { get; set; }

        public string CreateUri { get; set; }

        public string UpdateUri { get; set; }

        public string CancelUri { get; set; }

        public string MediaType { get; set; }

        public string SchemaPath { get; set; }

        public string SchemaNamespace { get; set; }

        public bool EnableLogging { get; set; }

        /// <summary>
        /// Gets/Sets RefererUri
        /// </summary>
        public string RefererUri { get; set; }
    }
}